XIncludeFile "masks.pbi"

Procedure Masks_editor()
  If OpenWindow(#Window_tiles_editor, #Window_tiles_editor_x, #Window_tiles_editor_y, #Window_tiles_editor_w, #Window_tiles_editor_h, "Masks editor", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    Protected i.l = 0, img.l
    If isset > 0
      Protected selected_brush.l = GetGadgetState(#BrushesListIcon)
    EndIf
    ListIconGadget(#TilesListIcon, #TilesListIcon_x, #TilesListIcon_y, #TilesListIcon_w, #TilesListIcon_h, "Mask", #TilesColumn1_w+5, #PB_ListIcon_FullRowSelect | #PB_ListIcon_AlwaysShowSelection)
    AddGadgetColumn(#TilesListIcon, 2, "ID", #TilesColumn2_w)
    AddGadgetColumn(#TilesListIcon, 3, "File", #TilesColumn3_w)
    ForEach masks()
      img = ImageID(LoadImage(#PB_Any, "masks"+#Path_separator+masks()))
      AddGadgetItem(#TilesListIcon, -1, Chr(10)+MapKey(masks())+Chr(10)+masks(), img)
      SetGadgetItemData(#TilesListIcon, i, img)
      i+1
    Next
    ButtonImageGadget(#UpButton, #UpButton_x, #UpButton_y, #UpButton_w, #UpButton_h, ImageID(CatchImage(#PB_Any, ?Up_icon)))
    GadgetToolTip(#UpButton, "Up")
    DisableGadget(#UpButton, 1)
    ButtonImageGadget(#DownButton, #DownButton_x, #DownButton_y, #DownButton_w, #DownButton_h, ImageID(CatchImage(#PB_Any, ?Down_icon)))
    GadgetToolTip(#DownButton, "Down")
    DisableGadget(#DownButton, 1)
    ButtonImageGadget(#AddButton, #AddButton_x, #AddButton_y, #AddButton_w, #AddButton_h, ImageID(CatchImage(#PB_Any, ?Plus_icon)))
    GadgetToolTip(#AddButton, "Add")
    ButtonImageGadget(#RemoveButton, #RemoveButton_x, #RemoveButton_y, #RemoveButton_w, #RemoveButton_h, ImageID(CatchImage(#PB_Any, ?Minus_icon)))
    GadgetToolTip(#RemoveButton, "Remove")
    DisableGadget(#RemoveButton, 1)
    ButtonGadget(#OKButton2, #OKButton2_x, #OKButton2_y, #OKButton2_w, #OKButton2_h, "Ok")
    ButtonGadget(#CancelButton2, #CancelButton2_x, #CancelButton2_y, #CancelButton2_w, #CancelButton2_h, "Cancel")
    CopyMap(brushes(), brushes_temp())
    Protected file.s, tiles_path.s = "masks"+#Path_separator, filter.s = "mask (*.bmp)|*.bmp", ok.l = 0, quit.l = 0
    DisableWindow(#Window, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #TilesListIcon
              If GetGadgetState(#TilesListIcon) <> -1
                If GetGadgetState(#TilesListIcon) <> 0
                  DisableGadget(#UpButton, 0)
                Else
                  DisableGadget(#UpButton, 1)
                EndIf
                If GetGadgetState(#TilesListIcon) <> CountGadgetItems(#TilesListIcon)-1
                  DisableGadget(#DownButton, 0)
                Else
                  DisableGadget(#DownButton, 1)
                EndIf
                DisableGadget(#RemoveButton, 0)
              Else
                DisableGadget(#UpButton, 1)
                DisableGadget(#DownButton, 1)
                DisableGadget(#RemoveButton, 1)
              EndIf
            Case #UpButton
              i = GetGadgetState(#TilesListIcon)
              AddGadgetItem(#TilesListIcon, i-1, Chr(10)+Chr(10)+GetGadgetItemText(#TilesListIcon, i, 2), GetGadgetItemData(#TilesListIcon, i))
              SetGadgetItemData(#TilesListIcon, i-1, GetGadgetItemData(#TilesListIcon, i+1))
              RemoveGadgetItem(#TilesListIcon, i+1)
              reindex()
              SetGadgetState(#TilesListIcon, i-1)
            Case #DownButton
              i = GetGadgetState(#TilesListIcon)
              AddGadgetItem(#TilesListIcon, i+2, Chr(10)+Chr(10)+GetGadgetItemText(#TilesListIcon, i, 2), GetGadgetItemData(#TilesListIcon, i))
              SetGadgetItemData(#TilesListIcon, i+2, GetGadgetItemData(#TilesListIcon, i))
              RemoveGadgetItem(#TilesListIcon, i)
              reindex()
              SetGadgetState(#TilesListIcon, i+1)
            Case #AddButton
              file = OpenFileRequester("Add mask...", tiles_path, filter, 0)
              If file
                img = ImageID(LoadImage(#PB_Any, file))
                AddGadgetItem(#TilesListIcon, -1, Chr(10)+Str(CountGadgetItems(#TilesListIcon))+Chr(10)+GetFilePart(file), img)
                SetGadgetItemData(#TilesListIcon, CountGadgetItems(#TilesListIcon)-1, img)
              EndIf
              SetGadgetState(#TilesListIcon, CountGadgetItems(#TilesListIcon)-1)
            Case #RemoveButton
              ForEach brushes_temp()
                If brushes_temp()\mask >= GetGadgetState(#TilesListIcon)
                  brushes_temp()\mask-1
                EndIf
              Next
              RemoveGadgetItem(#TilesListIcon, GetGadgetState(#TilesListIcon))
              reindex()
            Case #OKButton2
              ok = 1
              quit = 1
            Case #CancelButton2
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      ClearMap(masks())
      For i = 0 To CountGadgetItems(#TilesListIcon)-1
        masks(Str(i)) = GetGadgetItemText(#TilesListIcon, i, 2)
      Next
      RemovePreferenceGroup("mask")
      PreferenceGroup("mask")
      WritePreferenceLong("masks", MapSize(masks()))
      PreferenceComment("Masks list")
      ForEach masks()
        WritePreferenceString(MapKey(masks()), masks())
      Next
      ClosePreferences()
      OpenPreferences(#CONFIG_FILE)
      If isset > 0
        CopyMap(brushes_temp(), brushes())
        ClearGadgetItems(#BrushesListIcon)
        RefreshBrushes()
        SaveBrushes()
        SetGadgetState(#BrushesListIcon, selected_brush)
      EndIf
    EndIf
    CloseWindow(#Window_tiles_editor)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure
; IDE Options = PureBasic 5.00 (Windows - x86)
; CursorPosition = 12
; Folding = -
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\